import re
import time
import os
import sys

import pressKeysCtypes as pk

frogDir = r"D:\Games\roguelikes\frogcomposband-7.1.salmiak-win"
userDir = frogDir + r"\lib\user"
screenshotPath = userDir + "\screen.txt"
regString = (
    r'\(\dd[2-9]\d\)'       # Large dice weapons
    r'|Power Dragon'        # god armour
    r'|\) ].*/'             # slaying gloves
    r'|].*Feanor'           # boots of feanor
    r'|Detection'           # rods of detection       
    r'|_.*Restore Mana'     # staves of restore mana
    )
shopRegex = re.compile(regString)

# Quit when less than 200K gold remaining
goldRegex = re.compile(r"Gold Remaining: 1\d\d.*k|You don't have enough gold")

def shuffleShop():
    pk.keyShiftPress('s')
    time.sleep(0.05)
    pk.keyPress('y')
    time.sleep(0.05)

def screenshot():
    # Assumes that the player has set f11 as a screenshot macro in the game
    # Screenshot macro is \x1d
    pk.keyPress('f11')

def readScreenshot():
    # Give time for file to update before reading
    time.sleep(0.08)
    # Try a few times to open the file since there is sometimes delay in creating it
    attempts = 10
    for i in range(attempts+1):
        time.sleep(0.02*i)
        if os.path.exists(screenshotPath):
            with open(screenshotPath) as f:
                screen = f.read()
            break
        else:
            if i < attempts:
                continue
            else:
                input("Remember to define a screenshot macro")
                sys.exit()
    lines = screen.split('\n')
    try:
        os.replace(screenshotPath,userDir + "\screenPrev.txt")
    except PermissionError:
        # print('File busy')
        time.sleep(0.05)
        os.replace(screenshotPath,userDir + "\screenPrev.txt")
    return lines

def findMatches(lines):
    matchFound = False
    for line in lines:
        mo = shopRegex.search(line)
        if mo:
            print(line)
            matchFound = True
        goldCheck(line)
    return matchFound

def goldCheck(line):
    if goldRegex.search(line):
        input("Stopping, gold less than 200k")
        sys.exit()

def main():
    time.sleep(3)
    while True:
        shuffleShop()
        screenshot()
        lines = readScreenshot()
        matchFound = findMatches(lines)
        if matchFound:
            input("Press enter to continue")
            time.sleep(2)

if __name__ == "__main__":
    main()