#undef windos
#ifdef _WIN32
# define windos 1
# include "windows.h"
#endif /* TODO: handle dos maybe */

#include "stdio.h"
#include "time.h"
#include "stdlib.h"

#ifndef windos
# include "termios.h"
# include "unistd.h"
#endif

#ifdef windos
# include "conio.h"
#endif

#define TRUE  0xFF
#define FALSE 0x00
#define randint(x) (rand_int (x) + 1)
#define ABS(a) ((a)>0 ? (a):-(a))

/* Simple roguelike UI should never use signed or more then 16bit int */
typedef unsigned char bool;
typedef unsigned char byte;
typedef unsigned short u16;
/* Just for RNG */
#if __WORDSIZE == 64
typedef unsigned int u32;
#else
typedef unsigned long u32;
#endif
typedef struct frame_type frame_type;
typedef struct message_type message_type;
typedef struct target_type target_type;

/* frame buffer */
struct frame_type
{
  /* info (char/attr) */
  byte * ch;
  byte * attr;
  /* If something was changed */
  /* Just in case we think, our output is very slow (ssh over bad connection) */
  /* Btw simple memory operations are allways fast, no matter how much we do */
  byte * changed;
  /* size */
  byte x;
  byte y;
  /* how many characters recently changed ? */
  u16 need_update;
};

#define MSG_SIZE 80
/* message buffer */
struct message_type
{
  /* TODO: improve */
  byte * string;
  byte attr [10];
  bool position;
};

enum ti_flags
{
  TI_SPOT = 0x01,
  TI_BLOCK = 0x02,
  TI_OK = 0x04
};

struct target_type
{
  byte x0;
  byte y0;
  byte x1;
  byte y1;
  byte x2;
  byte y2;
  byte * info;
};

extern frame_type frame_buffer;
extern message_type message_buffer;
extern FILE * save_file;
extern FILE * log_file;
extern bool do_save;
extern bool replay;
extern u32 seed;
extern const char dx[10];
extern const char dy[10];

/* functions of UI layer */
extern void init_ui (void);
extern void close_ui (void);
/* key bindings */
extern byte command (void);
/* ask for keypress / string. info type depends on 'what' value
   hackish and potentially buggy */
extern void ask_player (byte what, byte * info, byte * result);
/* For use by look command and ranged attacks */
extern bool set_target (target_type * t);
/* message */
extern void give_msg (byte typ, byte * str);
/* request immediate redraw of stuff (for projections, etc.) */
extern void redraw (void);
/* Simple functions */
extern void str_copy (byte * from, byte * to, u16 n, byte fill);
extern void wait_msec (u16 w);

/* functions of the 'game' layer */
/* request update of frame buffer (screen size changed, game loaded, etc.) */
extern void update (void);
/* everything else */
extern bool do_command (byte cmd);
/* save / load */
extern void init_game (void);
extern void close_game (void);
extern void save_game (FILE * f);
extern byte load_game (FILE * f);
/* what else ????? */
