/* Screen position (may be variable as well) */
#define MAP_COL 14
#define MAP_ROW 0
/* Dungeon chunk (level) size. */
#define DUN_X 66
#define DUN_Y 22
#define DUN_S (DUN_X * DUN_Y)
/* Map size 3x3x2 chunks */
/* All map handled as a single array of cells */
#define MAP_X 3
#define MAP_Y 3
#define MAP_Z 2
#define MAP_S (DUN_S * MAP_X * MAP_Y * MAP_Z)

/* Array index for a given location */
#define MAP_IDX(X,Y) \
(X + Y * DUN_X + map_x * DUN_S + map_y * MAP_X * DUN_S +\
 map_z * MAP_X * MAP_Y * DUN_S)

enum terran_types
{
  /* empty */
  T_NONE = 0,
  T_FLOOR = 1,
  /* walls */
  T_WALL = 20,
  /* doors */
  T_DOOR = 30,
  /* fun stuff */
  T_TREE = 40,
  T_FIRE = 41
};

/* current chunk location */
extern byte map_x, map_y, map_z, map_t, num_e, num_f;

struct map_cell
{
  /* From start we define how it looks like and what it is separately */
  /* how it looks (remembered by @ as) */
  byte looks_ch;
  byte looks_at;
  /* what it is indeed (we update looks if @ see the grid) */
  byte terr;
  /* 254 mobs enough for 66x22 level
     (mob / obj lists a separate for different chunks) */
  byte mob;
  byte obj;
};

extern struct map_cell * world_map;

extern u16 num_fires;

extern byte * view;

struct mob_type
{
  /* How it looks like (may change dynamically) */
  byte ch;
  byte at;
  /* Where it is. We simply remove dead mobs setting x=y=255 */
  byte y;
  byte x;
  byte oy;
  byte ox;
  /* It stares at the location of (255 is nothing) */
  byte tx;
  byte ty;
  /* How it moves */
  byte en; /* Timer: normal move consumes 25, add by 5, can move at 250 */
  byte mt; /* Move time: about 100 (50--200 maybe) */
  /* Stats */
  byte heal_charges; /* potions */
  byte haste_charges; /* potions */
  byte fire_charges; /* Wands */
  byte ice_charges; /* Wands */
  byte throw_charges; /* Rocks */
  byte hp;
  byte will;
  byte r; /* race index, reference to everything else */
  byte ma; /* Melee attack index */
  byte stun;
  byte dot;
  byte reg;
};

extern struct mob_type * mobs;

struct melee_attack
{
  byte speed;
  byte damage;
  byte chance;
  byte AC_mult;
  byte slay;
  byte drain_hp;
};

struct melee_attack ma_info [11];

#define MR_MAX 7
struct mob_race
{
  byte ch;
  byte at;
  byte str;
  byte dex;
  byte mwill;
  byte slay;
  byte move; /* free movement in forest */
  byte AC;
  byte a1; /* Optional attack methods */
  byte a2;
  byte a3;
  byte pow;
};

struct mob_race mr_info [MR_MAX];

extern byte mob_num;

void add_mob (byte x, byte y);

extern void do_map_test (void);

u16 distance (u16 x, u16 y, u16 x1, u16 y1);