/*
 * (c) 2010 Federico Poloni f.poloni@sns.it
 * available under one of the following licenses:
 * -Creative Commons Attribution-NonCommercial-ShareAlike 3.0
 * -GPL 2 or later
 */

usepackage("color","usenames");
texpreamble("\definecolor{LightGray}{gray}{0.95}");
texpreamble("\definecolor{DarkGray}{gray}{0.3}");
//ripped from src/variable.c
texpreamble("\definecolor{TERM_WHITE}{RGB}{255,255,255}");
texpreamble("\definecolor{TERM_SLATE}{RGB}{128,128,128}");
texpreamble("\definecolor{TERM_ORANGE}{RGB}{255,128,0}");
texpreamble("\definecolor{TERM_RED}{RGB}{192,0,0}");
texpreamble("\definecolor{TERM_GREEN}{RGB}{0,128,64}");
texpreamble("\definecolor{TERM_BLUE}{RGB}{0,64,255}");
texpreamble("\definecolor{TERM_UMBER}{RGB}{128,64,0}");
texpreamble("\definecolor{TERM_L_DARK}{RGB}{96,96,96}");
texpreamble("\definecolor{TERM_L_WHITE}{RGB}{192,192,192}");
texpreamble("\definecolor{TERM_YELLOW}{RGB}{255,255,0}");
texpreamble("\definecolor{TERM_L_RED}{RGB}{255,64,64}");
texpreamble("\definecolor{TERM_L_GREEN}{RGB}{0,255,0}");
texpreamble("\definecolor{TERM_L_BLUE}{RGB}{0,0,255}");
texpreamble("\definecolor{TERM_L_UMBER}{RGB}{192,128,64}");

texpreamble("\definecolor{TERM_VIOLET}{RGB}{144,32,255}");


string monster_letter(string s, string col="Black"){
string latexcolor="black";
if(col=="v") latexcolor="TERM_VIOLET";
if(col=="D") latexcolor="TERM_L_DARK";
if(col=="r") latexcolor="TERM_RED";
if(col=="R") latexcolor="TERM_L_RED";
if(col=="w") latexcolor="TERM_WHITE";
if(col=="y") latexcolor="TERM_YELLOW";
if(col=="u") latexcolor="TERM_UMBER";
if(col=="g") latexcolor="TERM_GREEN";
if(col=="G") latexcolor="TERM_L_GREEN";
if(col=="o") latexcolor="TERM_ORANGE";
if(col=="s") latexcolor="TERM_SLATE";
if(col=="W") latexcolor="TERM_L_WHITE";
if(col=="B") latexcolor="TERM_L_BLUE";
if(col=="U") latexcolor="Bittersweet";

return "\colorbox{black}{\color{"+latexcolor+"}\bfseries \ttfamily "+s+"\vphantom{pM}}";
};

size(50cm);
real midsize=2;
//draw((midsize,0.5)--(midsize,-100.5)--(-midsize,-100.5)--(-midsize,0.5)--cycle);
for(int i=0;i<=100;i+=1){
  filldraw((-midsize,-i+0.5)--(midsize,-i+0.5)--(midsize,-i-0.5)--(-midsize,-i-0.5)--cycle,(i%2==0)?palered:paleblue,defaultpen);
  if(i%10==0){
    string str=format("\center\bfseries %d ft",i*50);
    label(minipage(str,1.5cm),(0,-i));
  }
  else{
    string str=format("\center\footnotesize %d",i);
    label(minipage(str,1.5cm),(0,-i));    
  }
}

label("{\Large\color{Red} Angband native monster depths}",(-20,-1));
label("{\small based on r2031}",(-20,-2.2));

void place_event(string lbl, int lvl, pair direction=(0,0), real shift=0, pen p=currentpen){
  if(direction==(0,0))
    direction=(lvl%2==0)?E:W;
  pair position=(2*midsize*((direction.x>0)?1:-1),-lvl-shift);

  pair hook=((position.x>0)?midsize:-midsize,-lvl);
  p=p+overwrite(Move);
  Label l=Label(lbl,position,align=direction,p);
  label(l);
  draw(hook--position,arrow=Arrow(arrowhead=SimpleHead));
}

void place_monster(string lbl, string letter, string col, string abilities="", int lvl, pair direction=(0,0), real shift=0, pen p=currentpen){
  string full_line=lbl+monster_letter(letter,col);
  if(length(abilities)>0)
    full_line+="{\footnotesize("+abilities+")}";
  place_event(full_line,lvl,direction,shift,p);
};

place_event("town --- TO DO: buy lantern, kill Morgoth",0);
place_monster("Sauron","p","v","mana/darkness storms (550), drains charges, summons uniques --- quest monster", 99);
place_monster("Morgoth","P","D","mana storms (555), summons uniques --- quest monster",100);

place_monster("Farmer Maggot's dogs","C","v",2,shift=+2);
place_monster("Novice mage","p","r","blind and confuse spells",2);
place_monster("Red naga","n","r","hits to drain str",7);
place_monster("Wormtongue","p","v","frost bolt, poison ball, traps",8);
place_monster("Baby elemental dragons","d","w","corresp. element or poison breath (29)",9);
place_monster("Baby multi-hued dragon","d","r","elements and poison breath (38)",11);
place_monster("Gnome mage","h","r","summons, frost bolt",11);
place_monster("Moaning spirit","G","u","invisible, hits to drain dex",12);
place_monster("Homunculus","u","y","hits to paralyze",15);
place_monster("Hummerhorn","I","y","breeds, hits to confuse",16);
place_monster("Elemental hounds","Z","w","pack, breathes corresp. element (11)",18);
place_monster("Air hound","Z","g","pack, never sleeps, breathes poison (22)",20);
place_monster("Ibun and Khim","h","v","hits to disenchant",24);
place_monster("Carrion crawler","c","o","hits to paralyze",24);
place_monster("Vibration/Nexus hounds","Z","w","pack, breathes corresp. element",27,shift=-2);
place_monster("Black Knight","p","s","cause wounds (80)",28,shift=+2);
place_monster("Mind flayer","h","r","brain smash (96), paralyze, hits to drain int/wis",28,shift=+2);
place_monster("Young elemental dragons","d","w","breathes corresp. element (79)",29,shift=-2);
place_monster("Young green/bronze dragons","d","w","breathes corresp. element (79)",29);
place_monster("Shadow drake","d","G","passes walls, breathes nether (44)",33,shift=-2);
place_monster("Shelob","S","v","breathes poison (800), darkness (400), cause wounds spell (120)",55,direction=E,shift=+1);
place_monster("Balance drake","d","r","breathes sound, shards, chaos, disen (88)",33,shift=-2);
place_monster("Lich","L","o","hits to drain charges, brain smash (96)",34);
place_monster("Master vampire","V","g","nether bolt (99)",36);
place_monster("Gravity hound","Z","W","pack, breathes gravity (64)",35);
place_monster("Inertia hound","Z","W","pack, breathes inertia (32)",35);
place_monster("Dread","Z","W","pass walls, nether bolt (97)",35,shift=-2);
place_monster("Mature W/Bl/G dragon","d","w","breathes corresp. element (117)",34);
place_monster("Mature R/Bk dragon","d","r","breathes corresp. element (146)",36);
place_monster("Young multi-hued dragon","d","w","breathes elements/poison (93)",32);
place_monster("Time vortex","v","B","breathes time (58)",38);
place_monster("Ancient W/Bl/G dragon","D","w","quick, breathes corresp. element (211)",40);
place_monster("Ancient R/Bk dragon","D","w","quick, breathes corresp. element (293)",41,shift=-2);
place_monster("Seraph","A","r","mana bolts (129), summons",45,direction=E,shift=-0.5);
place_monster("Enchantress","A","r","very quick, summons dragons",40);
place_monster("Death drake","D","G","passes walls, breathes nether (308)",45,shift=-2);
place_monster("Great crystal drake","D","u","breathes shards (308)",45);
place_monster("Ancient Multi-hued dragon","D","r","quick, breathes elements+poison (616)",43,direction=E,shift=-1.5);
place_monster("Ethereal dragon","D","o","passes walls, breathes light/dark/conf (308)",45);
place_monster("Lesser Balrog","U","r","breathes fire (586), drains charges",49);
place_monster("Drolem","g","g","breathes poison (733), not detected by telepathy",44,shift=-1);
place_monster("Scatha the worm","D","v","breathes frost (733)",46);
place_monster("Smaug","D","v","breathes fire (800)",48);
place_monster("Dracolich","D","G","breathes frost (1026), nether (513)",55);
place_monster("Dracolisk","D","R","breathes fire (1026), nexus (400)",55);
place_monster("Itangast","D","v","breathes fire (733)",47);
place_monster("Glaurung","D","v","breathes fire (1600), poison (800)",70);
place_monster("Master mystic","p","o","very quick, hits (hard) to stun",50);
place_monster("Balrog of Moria","U","v","very quick, breathes fire (1000), drains charges",50);
place_monster("Time hound","Z","B","pack, very quick, breathes time (110)",50,shift=+2);
place_monster("Great Storm/Ice Wyrm","D","w","breathes corresp. element  (1026)",63);
place_monster("Phoenix","B","v","breathes fire  (1200)",54);
place_monster("Nightcrawler","W","D","breathes nether  (406)",54);
place_monster("Lernean Hydra","M","v","breathes fire (1500), poison (800)",57);
place_monster("Great Hell/Bile Wyrm","D","w","breathes fire (1114)/acid (1026)",67);
place_monster("Uriel","A","v","breathes fire (1600)",61);
place_monster("Azriel","A","v","breathes nether (550)",62);
place_monster("Ancalagon","D","v","breathes elements (1600), poison (800)",85);
place_monster("Jabberwock","H","r","breathes chaos (469)",68);
place_monster("Great Wyrm of Chaos/Law","D","w","breathes chaos and disen/sound and shards (500)",75);
place_monster("Tselakus","G","v","darkness storms (395)",68);
place_monster("Great Wyrm of Many Colours","D","r","breathes elements (1466), poison (800)",79,direction=E);
place_monster("Black reaver","L","D","mana storms (425)",79);
place_monster("Feagwath","L","v","mana storms (440), drains charges",77,direction=E);
place_monster("Omarax","e","v","darkness storms (420), drains charges",73);
place_monster("Ungoliant","S","v","breathes poison (800)",75,direction=E);
place_monster("Aether hound","Z","v","pack, breathes elements (410), time (150), gravity (205)+others",74,shift=-1);
place_monster("Mouth of Sauron","p","v","mana storms (380), drains charges",65);
place_monster("Qlzqqlzuup","Q","v","very quick, summons every turn, summons uniques",79);
place_monster("Tarrasque","R","v","breathes (very frequently) fire/frost (1600), disen (500), drains charges",86);
place_monster("Lungorthin","U","v","breathes fire (1600), drains charges",88);
place_monster("Vecna","L","v","mana storms (515), drains charges",92);
place_monster("Huan","C","v","breathes frost (1600), light (400), sound/shards (500)",90);
place_monster("Carcharoth","C","v","breathes fire (1600), poison (800), nether (550), darkness (400)",90,direction=W);
place_monster("Gothmog","U","v","breathes fire (1600), drains charges",95);

place_monster("Winged Horror","B","D","breathes poison (337), nether/dark (168)",48);

place_monster("Bile Demon","U","R","breathes acid (821), poison (800)",61);
place_monster("Gelugon","U","w","breathes frost (1026), shards (500), summons",69,shift=+2);
place_monster("Pit fiend","U","o","breathes fire (1173), poison (800), chaos (500), summons",77);
place_monster("Greater Balrog","U","R","breathes fire (1466), drains charges",79,direction=E,shift=+2);
place_monster("Great Swamp Wyrm","D","g","breathes poison (800)",63);
place_monster("Great Wyrm of Perplexity","D","U","breathes confusion (400)",63,direction=E,shift=+1);
place_monster("Great Wyrm of Thunder","D","y","breathes sound (500)",67);

place_monster("Ranger","p","W","frost bolt (33), summons",20);

place_monster("Kronos","P","v","breathes fire/frost (1600), sound/shards (500)",87);

place_monster("Beholder hive-mother","e","b","darkness storms (390)",67,shift=+2);

place_monster("Ghoul","z","U","hits to paralyze, poison",26); //TODO: hold?

place_monster("Greater basilisk","R","D","hits to paralyze, breathes poison (336)",45,direction=E,shift=-0.5);

place_monster("Bat of Gorgoroth","b","g","pack, breathes poison (36)",28);

place_monster("Bronze golem","g","o","breathes fire (1173)",75,direction=E);

place_monster("Multi-hued hound","Z","v","pack, breathes elements+poison (73)",43,shift=-2);

place_monster("Cherub","A","G","very quick, summons",39,shift=-2);

place_monster("Harowen","p","v","incredibly quick, hits to blind/poison",51);

place_monster("Gauth","e","D","drains charges",36);
place_monster("Storm of unmagic","v","v","drains charges",53);

place_monster("Maeglin","h","v","summons uniques",81);

