/* signals.c: signal handlers */
/* bcn -- update (rewrite) for current posix compliance  Oct2013 */

#include <stdio.h>
#include "config.h"
#include <signal.h>

#include "constant.h"
#include "types.h"
#include "externs.h"


static void
do_panic_save(int sig)
{
  char panicSaveFile[1024];

  prt(
"OH NO!!!!!!  A gruesome software bug LEAPS out at you. There is NO defense!",
      23, 0);
  prt("Your guardian angel is trying to save you.", 0, 0);
  (void) sprintf(panicSaveFile, "%s.panic", savefile);
  (void) _save_char(panicSaveFile);
  restore_term();
  exit(1);
}




/* Don't allow reciept of signals */
void
nosignals()
{
  /* Ignore this for now; always accept signals */
}

/* Restore receiving signals */
void
signals()
{
/* Since we do not currently ever turn off receipt of signals, we
 * don't need to do anything regarding restoring receipt of signals.
 */
}



/* Set up some rudimentary signal handling.
 * Use Posix "sigaction" rather than the older "signal" interface.
 */
void
init_signals()
{
  struct sigaction sa;

  sa.sa_flags = 0;
  (void) sigemptyset(&(sa.sa_mask));

  /* Ignore these */
  sa.sa_handler = SIG_IGN;
  (void) sigaction(SIGINT, &sa, NULL);
  (void) sigaction(SIGHUP, &sa, NULL);
  (void) sigaction(SIGCHLD, &sa, NULL);

  /* Try to do a panic save with these signals */
  sa.sa_handler = do_panic_save;
  (void) sigaction(SIGFPE, &sa, NULL);
  (void) sigaction(SIGILL, &sa, NULL);
  (void) sigaction(SIGTRAP, &sa, NULL);
  (void) sigaction(SIGIOT, &sa, NULL);
  (void) sigaction(SIGBUS, &sa, NULL);
  (void) sigaction(SIGSEGV, &sa, NULL);
  (void) sigaction(SIGSYS, &sa, NULL);
  (void) sigaction(SIGPIPE, &sa, NULL);

  /* Not so clear about these */
  sa.sa_handler = do_panic_save;
  (void) sigaction(SIGTERM, &sa, NULL);
  (void) sigaction(SIGQUIT, &sa, NULL);

  /* Note that SIGKILL and SIGSTOP cannot be caught */
}

