use strict;
use warnings "all";
use Carp;
# finesse dice should always be more than this much * number of faces
my $face_constraint=2;
# prowess faces should always be more than this much * number of dice
my $dice_constraint=4;

my $face_map=[map{$_*$_*$face_constraint/2+$_*$face_constraint/2}(1..10)];
my $dice_map=[map{$_*$_*$dice_constraint/2+$_/2}(1..10)];

sub round
{
	my $val=shift;
	if ($val<0){ $val-=0.5;}
	else 	   {$val +=0.5;}
	return int($val);
}

#component to solve for is die size for finesse characters
#or dice count for prowess characters.
#the factor not solved for here should be much larger and thus
#easier to step.
sub map_damage_to_component
{
	my ($damage,$componentmap)=@_;
	my $component=0;
	foreach my $score(@$componentmap)
	{
		last if ($damage <$score);
		$component++;
	}
	$component=1 if($component==0);
	return $component;
}
# dam = dice * (faces + 1)/2
sub dice_faces_to_damage
{
	my ($dice,$faces)=@_;
	return $dice * ($faces +1)/2;
}

sub damage_faces_to_dice
{
	my ($damage,$faces)=@_;
	return round($damage*2/($faces+1))
}

sub damage_dice_to_faces
{
	my ($damage,$dice)=@_;
	return round($damage*2/$dice-1);
}
	
sub dice_faces_to_sd
{
	my ($dice,$faces)=@_;
	return sqrt($dice *( $faces**2-1)/12);
}
sub damage_to_prow_dice
{
	my $damage=shift(@_);
	my $prow_dice= map_damage_to_component($damage,$dice_map);
	my $prow_faces= damage_dice_to_faces($damage,$prow_dice);
	return [$prow_dice,$prow_faces];
}
sub damage_to_fin_dice
{
	my $damage=shift(@_);
	my $fin_faces= map_damage_to_component($damage,$face_map);
	my $fin_dice= damage_faces_to_dice($damage,$fin_faces);
	return [$fin_dice,$fin_faces];
}

sub rebalance
{
	my $in=shift(@_);
	my $fin_boost=1;
	#split the input: P:0:1d12:0:0:0:20:80
	#We are interested in fields 2, -2, -1
	my @entries=split(/:/,$in);
	my ($d_string,$fin,$prow)=@entries[2,-2,-1];

	# an 80:20 weapon is "pure"
	my $real_fin=$fin>80?1:($fin<20?0:($fin-20)/60);
	my $real_prow=$prow>80?1:($prow<20?0:($prow-20)/60);
	# sometimes finesse + prow don't sum to 1
	my $overage = $real_fin + $real_prow;
	confess("what the hell: got $in\n") if $overage <1;
	$real_fin/=$overage;
	$real_prow/=$overage;
	
	#figure out what the right dice would be for pure prow or finesse
	my $base_damage=dice_faces_to_damage(split(/d/,$d_string));
	# add a boost for finesse since we think that's underpowered.
	if($real_fin>.5)
	{
		$base_damage+=($real_fin-.5) * $fin_boost;
	}

	my $prow_dice = damage_to_prow_dice($base_damage);
	my $fin_dice = damage_to_fin_dice($base_damage);

	#try two different strategies for balance -- all else equal 
	#prefer mixing dice as this gives "square" weapons like 4d4

	my $bal1_dice = round($prow_dice->[0]*$real_prow + $fin_dice->[0]*$real_fin);
	my $bal1_faces = damage_dice_to_faces($base_damage,$bal1_dice);
	my $bal2_faces = round($prow_dice->[1]*$real_prow + $fin_dice->[1]*$real_fin);
	my $bal2_dice = damage_faces_to_dice($base_damage,$bal2_faces);

	if(	abs(dice_faces_to_damage($bal1_dice,$bal1_faces) -$base_damage) >
		abs(dice_faces_to_damage($bal2_dice,$bal2_faces) -$base_damage) )
	{
		$d_string=$bal2_dice . "d" . $bal2_faces;
	}
	else
	{
		$d_string=$bal1_dice . "d" . $bal1_faces;
	}

	#restore field 2
	$entries[2]=$d_string;
	return join(":",@entries);
		


}
sub update_objs
{
	open (my $objfh,"<","object.txt") or die $!;
	my @lines =<$objfh>;
	chomp(@lines);
	close($objfh);
	open ($objfh,">","object.txt") or die $!;
	while(@lines)
	{		
		my $line=shift(@lines);
		print $objfh ($line."\n");
		last if $line=~/##\s*Weapons/i;
	}
	while(@lines)
	{
		my $line=shift(@lines);
		if($line=~/^\s*P:/)
		{
			$line=rebalance($line)
		}
		print $objfh ($line."\n");
		last if $line=~/##\s*Bows, Crossbows/i;
	}
	print $objfh (join("\n", @lines) . "\n");
}

update_objs();

sub spew_mappings
{
	print("|seed_dam|prow dice|prow dam|fin dice | fin dam|  bal_d1 |bal1 dam|".
		"  bal_d2 |b2 dam| prowsd||fin sd|bal1sd|bal2sd|\n");

	foreach my $damage (1..50)
	{
		
		my $prow_dice= map_damage_to_component($damage,$dice_map);
		my $fin_faces= map_damage_to_component($damage,$face_map);
		my $fin_dice= damage_faces_to_dice($damage,$fin_faces);
		my $fin_sd=dice_faces_to_sd($fin_dice,$fin_faces);
		my $prow_faces= damage_dice_to_faces($damage,$prow_dice);
		my $prow_damage=dice_faces_to_damage($prow_dice,$prow_faces);
		my $prow_sd=dice_faces_to_sd($prow_dice,$prow_faces);
		my $fin_damage=dice_faces_to_damage($fin_dice,$fin_faces);
		my $bal_1_dice = round(($prow_dice+$fin_dice)/2);
		my $bal_1_faces=damage_dice_to_faces($damage,$bal_1_dice);
		my $bal_1_damage=dice_faces_to_damage($bal_1_dice,$bal_1_faces);
		my $bal_1_sd=dice_faces_to_sd($bal_1_dice,$bal_1_faces);
		my $bal_2_faces = round(($prow_faces+$fin_faces)/2);
		my $bal_2_dice=damage_faces_to_dice($damage,$bal_2_faces);
		my $bal_2_damage=dice_faces_to_damage($bal_2_dice,$bal_2_faces);
		my $bal_2_sd=dice_faces_to_sd($bal_2_dice,$bal_2_faces);

		     #("|seed_dam|prow dice| prow dam|fin dice | fin dam | bal_d1 | prowsd | fin sd| bal1 sd|\n");
		printf( "   %3d   | %3dd%3d |  %4.1f  | %3dd%3d |  %4.1f  ".
			"| %3dd%3d |  %4.1f  | %3dd%3d | %4.1f |".
			"|  %4.1f |  %4.1f|  %4.1f|  %4.1f|\n",
			$damage, $prow_dice,$prow_faces, $prow_damage, 
				 $fin_dice,$fin_faces, $fin_damage,
				 $bal_1_dice,$bal_1_faces, $bal_1_damage,
				 $bal_2_dice,$bal_2_faces, $bal_2_damage,
				 $prow_sd,$fin_sd,$bal_1_sd,$bal_2_sd);
	}

}
