#WindowsClient.py
import os, sys
import pygame
from pygame.locals import *

from Angband import *
from Commands import *
from Directions import *

import cProfile

KEYCONVERT = {
    K_UP:           AKEY_UP,
    K_DOWN:         AKEY_DOWN,
    K_LEFT:         AKEY_LEFT,
    K_RIGHT:        AKEY_RIGHT,
    K_KP0:          '0',
    K_KP1:          '1',
    K_KP2:          '2',
    K_KP3:          '3',
    K_KP4:          '4',
    K_KP5:          '5',
    K_KP6:          '6',
    K_KP7:          '7',
    K_KP8:          '8',
    K_KP9:          '9',
    K_KP_PERIOD:    '.',
    K_KP_DIVIDE:    '/',
    K_KP_MULTIPLY:  '*',
    K_KP_MINUS:     '-',
    K_KP_PLUS:      '+',
    K_KP_ENTER:     '\r',
    '!-':           '_',
    '!=':           '+',
    '![':           '{',
    '!]':           '}',
    '!\\':          '|',
    '!\'':          '"',
    '!;':           ':',
    '!,':           '<',
    '!.':           '>',
    '!/':           '?',
    '!1':           '!',
    '!2':           '@',
    '!3':           '#',
    '!4':           '$',
    '!5':           '%',
    '!6':           '^',
    '!7':           '&',
    '!8':           '*',
    '!9':           '(',
    '!0':           ')',
}

class WindowsClient:
    def __init__(self):
        window_size = (800, 600)
        pygame.init()
        self._prompt = ''
        self._screen = pygame.display.set_mode(window_size, 0, 8)
        pygame.display.set_caption('pyAngband Alpha 0.1 Win-pyGame')
        self._bgcolor = (0, 0, 0)
        self._screen.fill(self._bgcolor)
        self._running = True
        self._font_size = 12
        
        self._font = pygame.font.Font('VeraMoBd.ttf', self._font_size)
        if(not self._font):
            print("Font not loaded!")
            exit()
        metric = self._font.metrics('@')[0]
        self._font_w = metric[4]
        self._font_h = self._font_size + 2
        
    def putch_at(self, char, x, y, color):
        drawme = self._font.render(char, True, color, self._bgcolor)
        self._screen.blit(drawme, (x * self._font_w, y * self._font_h))
    
    def puts_at(self, str, x, y, color):
        drawme = self._font.render(str, True, color, self._bgcolor)
        self._screen.blit(drawme, (x * self._font_w, y * self._font_h))
    
    def erase_at(self, len, x, y, color = None):
        erase_me = pygame.Surface((len * self._font_w, self._font_h), 0, 8)
        if not color:
            erase_me.fill(self._bgcolor)
        else:
            erase_me.fill(color)
        self._screen.blit(erase_me, (x * self._font_w, y * self._font_h))
        
    def run(self):
        game = Angband(self)
        changed = True
        while(self._running):
            disp = game.get_current_display()
            plr = disp[0]
            gmap = disp[1]
            self._screen.fill(self._bgcolor, Rect(0, 0, 800, 600))
            mr = 0
            mc = 0
            for row in gmap[0]:
                for col in row:
                    ccolor = (200, 200, 200)
                    if(col == '.'): ccolor = (150, 150, 150)
                    elif(col == '1'): ccolor = (150, 150, 0)
                    elif(col == '+'): ccolor = (100, 60, 40)
                    self.putch_at(col, mc, mr + 1, ccolor)
                    mc += 1
                mc = 0
                mr += 1
            self.putch_at(plr[0], plr[1], plr[2] + 1, (255, 255, 255))    
            pygame.display.flip()
            key = None
            while(key == None):
                key = self.get_key()
            cmd = cmd_from_keypress(key)
            #print("code: "+ str(cmd.code()))
            game.queue_command(cmd)
            game.run()
            if(not game.running()):
                self._running = False

    def prompt_direction(self):
        self.puts_at("Direction?", 0, 0, (255, 255, 255))
        pygame.display.flip()
        while(1):
            key = self.get_key()
            if(key in DIRECTION_BINDINGS):
                return DIRECTION_BINDINGS[key]
            return None    
        self.erase_at(len("Direction?", 0, 0))
        
    def prompt(self, msg):
        self.erase_at(60, 0, 0)
        self.puts_at(msg, 0, 0, (255, 255, 255))
        pygame.display.flip()
        
    def inkey_instant(self):
        return True in pygame.key.get_pressed()
        
    def get_key(self):
        while(1):
            events = pygame.event.get()
            for e in events:
                if(e.type == QUIT):
                    sys.exit(0)
                elif(e.type == KEYDOWN):
                    sh = (e.mod & KMOD_SHIFT)
                    alt = (e.mod & KMOD_ALT)
                    ctrl = (e.mod & KMOD_CTRL)
                    keychar = ''
                    if(ctrl): keychar = '^'
                    if(e.key == 27):
                        return AKEY_ESCAPE
                    if(sh and e.key >= 97 and e.key <= 122): keychar += chr(e.key - 32)
                    elif(sh and e.key <= 126): 
                        code = '!' + chr(e.key)
                        if(code in KEYCONVERT):
                            keychar += KEYCONVERT[code]
                    elif(e.key <= 126): keychar += chr(e.key)
                    elif(e.key in KEYCONVERT): keychar += KEYCONVERT[e.key]
                    return keychar
                        
if(__name__ == '__main__'):
    client = WindowsClient()
    client.run()
    #cProfile.run('client.run()')