#MOVE_UP             = [AKEY_UP, '8']
#MOVE_DOWN           = [AKEY_DOWN, '2']
#MOVE_LEFT           = [AKEY_LEFT, '4']
#MOVE_RIGHT          = [AKEY_RIGHT, '6']
#MOVE_UP_AND_LEFT    = ['7']
#MOVE_UP_AND_RIGHT   = ['9']
#MOVE_DOWN_AND_LEFT  = ['1']
#MOVE_DOWN_AND_RIGHT = ['3']

AKEY_ESCAPE = '!!'
AKEY_UP     = '!u'
AKEY_DOWN   = '!d'
AKEY_LEFT   = '!l'
AKEY_RIGHT  = '!r'
    
#MOVEMENT_KEYS = [AKEY_UP, AKEY_DOWN, AKEY_LEFT, AKEY_RIGHT, '1', '2', '3', '4', '5', '6', '7', '8', '9'] #redfine later in options
#OPEN_KEY = 'o'

MAX_DIRECTIONS = 9
(   NO_DIRECTION,
    UP,
    DOWN,
    LEFT,
    RIGHT,
    UP_AND_LEFT,
    UP_AND_RIGHT,
    DOWN_AND_LEFT,
    DOWN_AND_RIGHT,) = range(0, MAX_DIRECTIONS)

DELTAS = {
    NO_DIRECTION    : ( 0,  0),
    UP              : ( 0, -1),
    DOWN            : ( 0,  1),
    LEFT            : (-1,  0),
    RIGHT           : ( 1,  0),
    UP_AND_LEFT     : (-1, -1),
    UP_AND_RIGHT    : ( 1, -1),
    DOWN_AND_LEFT   : (-1,  1),
    DOWN_AND_RIGHT  : ( 1,  1),
}    
def delta_from_direction(direction):
    """ Return a tuple for a given direction code.
        Pre:    Direction is valid
        Post:   Return (delta x, delta y) for the direction code
                (0, 0) for NO_DIRECTION
    """
    return DELTAS[direction]