#This is it, real and true Angband
import sys
from Commands import *
from Creature.Player import Player

#Here is the test map, this needs to be its own structure!

test_map = [
        ['#','#','#','#','#','#','#','#','#','#'],
        ['#','.','.','.','.','#','.','.','.','#'],
        ['#','.','.','.','.','+','.','#','.','#'],
        ['#','.','#','#','.','#','.','.','.','#'],
        ['#','.','1','#','.','#','.','.','.','#'],
        ['#','.','#','#','.','#','#','.','#','#'],
        ['#','.','.','.','.','#','.','#','.','#'],
        ['#','.','.','.','.','#','#','.','#','#'],
        ['#','.','.','.','.','#','.','#','.','#'],
        ['#','#','#','#','#','#','#','#','#','#']]
map_rows = 10
map_cols = 10

        

#End test map

#a lot of this crap below this comment needs to be moved into its own file, but for now
#it's just easier to stack it up here.



MAX_STATES = 7
(   STATE_NONE,
    STATE_STARTUP,
    STATE_LOADCHARACTER,
    STATE_NEW,
    STATE_GAME,
    STATE_STORE,
    STATE_DEATH,) = range(0, MAX_STATES)

MAX_GAMESTATES = 4
(
    GAMESTATE_NONE,
    GAMESTATE_ENTER_TOWN,
    GAMESTATE_ENTER_DUNGEON,
    GAMESTATE_WAIT_FOR_PLAYER,) = range(0, MAX_GAMESTATES)

SPEED_OFFSET = 120    
EXTRACT_ENERGY = (
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    2,  2,  2,  2,  2,  2,  2,  3,  3,  3,
    3,  3,  3,  3,  3,  4,  4,  4,  4,  4,
    5,  5,  5,  5,  6,  6,  7,  7,  8,  9,
    10, 11, 12, 13, 14, 15, 16, 17, 18, 19, #Normal speed starts here at the beginning
    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
    30, 31, 32, 33, 34, 35, 36, 36, 37, 37,
    38, 38, 39, 39, 40, 40, 40, 41, 41, 41,
    42, 42, 42, 43, 43, 43, 44, 44, 44, 44,
    45, 45, 45, 45, 45, 46, 46, 46, 46, 46,
    47, 47, 47, 47, 47, 48, 48, 48, 48, 48,
    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
    49, 49, 49, 49, 49, 49, 49, 49, 49, 49)

def GET_ENERGY(speed):
    #If you somehow get insane speed, give back 50 energy, whereas if you have very very terrible speed,
    #at least give back 1 energy, otherwise follow the table.
    if(len(EXTRACT_ENERGY) < (SPEED_OFFSET + speed)):
        return 50
    elif(SPEED_OFFSET + speed < 0):
        return 1
    else:
        return EXTRACT_ENERGY[speed + SPEED_OFFSET]

def get_key_direction(keyval):
    if(keyval in MOVE_UP): return UP
    elif(keyval in MOVE_DOWN): return DOWN
    elif(keyval in MOVE_LEFT): return LEFT
    elif(keyval in MOVE_RIGHT): return RIGHT
    elif(keyval in MOVE_UP_AND_LEFT): return UP_AND_LEFT
    elif(keyval in MOVE_UP_AND_RIGHT): return UP_AND_RIGHT
    elif(keyval in MOVE_DOWN_AND_LEFT): return DOWN_AND_LEFT
    elif(keyval in MOVE_DOWN_AND_RIGHT): return DOWN_AND_RIGHT
    else: return NO_DIRECTION
        
def create_command(key):
    command_code = CMD_NONE
    cmd_data = None
    if(key[0] in MOVEMENT_KEYS):
        command_code = CMD_MOVE
        cmd_data = get_key_direction(key[0])
        return (command_code, cmd_data)

class Angband(object):
    """ The Angband class, this is the 'game', it controls everything and does everything.
        Angband has the following things:
            client      - a reference to the client controling angband, for prompts and such
            key_queue   - a queue for holding a tuple containing keypress information, special keys
                        are constants defined here, other keys are passed as a character 'x' or '9'
                        keys are not capital, check the shift status : key[1]
            cmd_queue   - the command queue
            game_turns  - current game turns
            player      - the instance of the player
            done        - flag to see if the game is done running (shutdown)
            state       - current macro-state the game is in
            gamestate   - current micro-state the game is in, applies to STATE_GAME macro-state only
            do_state    - a helper dictionary so there isn't a big chain of if/elif for state selection
    """
    def __init__(self, client):
        self._client = client
        self._key_queue = []    #keys are (key, shift, ctrl, alt, x, y) x, y are only for mouse presses
        self._cmd_queue = []
        self._game_turns = 0
        self._energy_use = 0
        self._player = Player()
        self._done = False
        self._state = STATE_STARTUP
        self._gamestate = GAMESTATE_NONE
        self._do_state =    {
                    STATE_NONE: self.state_nyi,
                    STATE_STARTUP: self.state_startup,
                    STATE_LOADCHARACTER: self.state_nyi,
                    STATE_NEW: self.state_nyi,
                    STATE_GAME: self.state_game,
                    STATE_STORE: self.state_nyi,
                    STATE_DEATH: self.state_nyi,
                            }
    
    def run(self):
        """ While the game has keys in its queue, run the game
            Precondition:   client is initialized, Angband is initialized
            Postcondition:  key_client is empty unless an error was thrown
        """
        while(self.has_commands()):
            self._do_state[self._state]()
    
    def has_commands(self):
        """ Check if there are commands left in the queue
            Pre: Angband is initialized
            Post: Return true if there are commands in the cmd_queue, else false
        """
        return len(self._cmd_queue) > 0
    
    def queue_command(self, command):
        """ Commands are as follows (command = (code, prompt, [tval]), arg)
        """
        self._cmd_queue.append(command)
        
    def get_command(self):
        if(len(self._cmd_queue) == 0):
            return None
        cmd = self._cmd_queue[0]
        self._cmd_queue = self._cmd_queue[1:]
        return cmd
    def unget_command(self, command):
        self._cmd_queue = [command].append(self._cmd_queue)
                   
    def get_current_display(self):
        """ Get the stuff that needs displaying
            No Pre/Post, this method will be removed as Angband is further developed
        """
        pxy = self._player.get_xy()
        return (('@', pxy[0], pxy[1]), (test_map, map_rows, map_cols))

    def shutdown(self):
        """Do everything that needs to be done to shutdown the game
            Pre:    Angband is initialized
            Post:   Angband will be ready to shutdown
        """
        self._done = True
        
    def running(self):
        """ Check if Angband is still running, as in not shut down
            Pre:    Angband is initialized
            Post:   Return true if Angband has not yet been shut down
                    Return false if Angband is ready to shut down
        """
        return(self._done == False)

    def state_nyi(self):
        """Placeholder function for states that are not yet implemented (nyi)"""
        print("This state is not yet implemented, sorry!")
    
    def state_startup(self):
        """ Startup state for Angband
            This function will be called once after the Angband instance is initialized
            All game data (edits) and such will be loaded here.
        """
        print("Starting up pyAngband!")
        self._state = STATE_GAME
        self._gamestate = GAMESTATE_ENTER_TOWN
    
    def state_game(self):
        """ Gameplay state for Angband
            The gameplay state is divided into a series of smaller, micro-states
        """
        #process the world every 10 game turns
        if(self._game_turns % 10 == 0):
            self.process_world()
        
        #if player has energy to move, do it
        if(self._player.energy() >= 100):
            self.process_player()
        
        #add some energy to the player
        self._player.add_energy(GET_ENERGY(self._player.speed()))
            
    def process_player(self):
        while(True):
            #no energy used yet
            self._energy_use = 0
            #did we do something?
            self.process_command()
            #if we did something leave, if the game is stopped, leave, if there is nothing to do, leave
            if(self._energy_use > 0 or not self.running() or not self.has_commands()): break
        if(self._energy_use > 0):
            #if we did something, better use the energy and add a turn
            self._player.use_energy(self._energy_use)
            self._player.add_turn()


    def try_move_player(self, direction):
        """ Try to move the player
            Pre: Angband is initialized and running in the gamestate
            Post:   Success: Player is moved, return True
                    Fail:    Player is not moved return False
        """
        
        #cannot move if the player does not have enough energy
        if(self._player.energy() < 100): return
        #get current player x and y
        pxy = self._player.get_xy()
        delta = delta_from_direction(direction)
        nx = pxy[0] + delta[0]
        ny = pxy[1] + delta[1]
        if(nx < 0 or nx >= len(test_map[0]) or ny < 0 or ny >= len(test_map)):
            return
        if(test_map[ny][nx] == '#'):
            return
        if(test_map[ny][nx] == '+'):
            return #handle auto-open here
        self._player.set_xy(nx, ny)
        #do searching?
        self._energy_use = 100
    
    def process_command(self):
        if(not self.has_commands()):
            #print("No commands pending.")
            return
        cmd = self.get_command()
        if(cmd.code() == CMD_QUIT):
            print("See ya!")
            sys.exit(0)
        elif(cmd.code() == CMD_MOVE):
            direction = cmd.arg()
            self.try_move_player(direction)
        elif(cmd.code() == CMD_MOVE_PD):
            direction = self.prompt_direction()
            if(direction != None):
                self.try_move_player(direction)
        elif(cmd.code() == CMD_OPEN):
            #here we gotta do some extra work for auto stuff
            #but for now it's fine without it.
            direction = self.prompt_direction()
            if(direction != None):
                delta = delta_from_direction(direction)
                pxy = self._player.get_xy()
                ox = pxy[0] + delta[0]
                oy = pxy[1] + delta[1]
                if(test_map[oy][ox] == '+'):
                    test_map[oy][ox] = '\''
                else:
                    self.prompt("You can't open that!")
        elif(cmd.code() == CMD_CLOSE):
            direction = self.prompt_direction()
            if(direction != None):
                delta = delta_from_direction(direction)
                pxy = self._player.get_xy()
                ox = pxy[0] + delta[0]
                oy = pxy[1] + delta[1]
                if(test_map[oy][ox] == '\''):
                    test_map[oy][ox] = '+'
                else:
                    self.prompt("You can't close that!")
    
    def prompt_direction(self):
        return self._client.prompt_direction()
    def prompt(self, msg):
        self._client.prompt(msg)
        
    def process_world(self):
        """Do stuff every 10 game turns"""
        #print("Processing world!")