import pygame, sys
from pygame.locals import *

window_size = (800, 600)
pygame.init()
screen = pygame.display.set_mode(window_size, 0, 8)
pygame.display.set_caption('pyAngband Alpha 0.1 Win-pyGame')
bgcolor = (0, 0, 0)
screen.fill(bgcolor)
font_size = 12

AKEY_UP = 500
AKEY_DOWN = 501
AKEY_LEFT = 502
AKEY_RIGHT = 503

KEYCONVERT = {
    K_UP:           AKEY_UP,
    K_DOWN:         AKEY_DOWN,
    K_LEFT:         AKEY_LEFT,
    K_RIGHT:        AKEY_RIGHT,
    K_KP0:          '0',
    K_KP1:          '1',
    K_KP2:          '2',
    K_KP3:          '3',
    K_KP4:          '4',
    K_KP5:          '5',
    K_KP6:          '6',
    K_KP7:          '7',
    K_KP8:          '8',
    K_KP9:          '9',
    K_KP_PERIOD:    '.',
    K_KP_DIVIDE:    '/',
    K_KP_MULTIPLY:  '*',
    K_KP_MINUS:     '-',
    K_KP_PLUS:      '+',
    K_KP_ENTER:     '\r',
    '!-':           '_',
    '!=':           '+',
    '![':           '{',
    '!]':           '}',
    '!\\':          '|',
    '!\'':          '"',
    '!;':           ':',
    '!,':           '<',
    '!.':           '>',
    '!/':           '?',
    '!1':           '!',
    '!2':           '@',
    '!3':           '#',
    '!4':           '$',
    '!5':           '%',
    '!6':           '^',
    '!7':           '&',
    '!8':           '*',
    '!9':           '(',
    '!0':           ')',
}
    

while(1):
    events = pygame.event.get()
    for e in events:
        if(e.type == QUIT):
            sys.exit(0)
        elif(e.type == KEYDOWN):
            if(e.key == 27): sys.exit(0)
            sh = (e.mod & KMOD_SHIFT)
            alt = (e.mod & KMOD_ALT)
            ctrl = (e.mod & KMOD_CTRL)
            keychar = ''
            if(ctrl): keychar = '^'
            if(sh and e.key >= 97 and e.key <= 122): keychar += chr(e.key - 32)
            elif(sh and e.key <= 126): 
                code = '!' + chr(e.key)
                if(code in KEYCONVERT):
                    keychar += KEYCONVERT[code]
            elif(e.key <= 126): keychar += chr(e.key)
            elif(e.key in KEYCONVERT): keychar += KEYCONVERT[e.key]
            print(keychar)
            