#command structure:
#command = (ID, prompt, type, tvals)
#   prompt is what type of thing it prompts for (none = no prompt)
#   prompt's can be item(list of tvals), spell, target, direction

from Directions import *    #get directional constants

MAX_PROMPTS = 5
(   PROMPT_NONE,
    PROMPT_ITEM,
    PROMPT_SPELL,
    PROMPT_TARGET,
    PROMPT_DIRECTION,) = range(0, MAX_PROMPTS)

MAX_COMMANDS = 9
(   CMD_NONE,       #do nothing
    CMD_QUIT,       #quit game
    CMD_SUICIDE,    #quit game, kill character
    CMD_CANCEL,     #clear next command in queue
    CMD_CLEAR,      #clear all commands from queue
    CMD_MOVE,       #move the player, may or may not prompt
    CMD_MOVE_PD,    #move, prompt for direction
    CMD_OPEN,       #prompt direction, try to open a chest or door
    CMD_CLOSE,      #prompt direction, try to close a door
) = range(0, MAX_COMMANDS)

#For keybindings (this is in client code mind you) change key types to match your I/O library type
MAX_DIR = 8


DIRECTION_BINDINGS = {
    AKEY_UP:    UP,
    AKEY_DOWN:  DOWN,
    AKEY_LEFT:  LEFT,
    AKEY_RIGHT: RIGHT,
    '1':        DOWN_AND_LEFT,
    '2':        DOWN,
    '3':        DOWN_AND_RIGHT,
    '4':        LEFT,
    '5':        NO_DIRECTION,
    '6':        RIGHT,
    '7':        UP_AND_LEFT,
    '8':        UP,
    '9':        UP_AND_RIGHT,
    }
    
KEYBINDINGS = {
    AKEY_ESCAPE: CMD_CANCEL,
    AKEY_UP: CMD_MOVE,
    AKEY_DOWN: CMD_MOVE,
    AKEY_LEFT: CMD_MOVE,
    AKEY_RIGHT: CMD_MOVE,
    '1': CMD_MOVE,
    '2': CMD_MOVE,
    '3': CMD_MOVE,
    '4': CMD_MOVE,
    '5': CMD_MOVE,
    '6': CMD_MOVE,
    '7': CMD_MOVE,
    '8': CMD_MOVE,
    '9': CMD_MOVE,
    '.': CMD_MOVE_PD,
    'o': CMD_OPEN,
    'c': CMD_CLOSE,
    '^x': CMD_QUIT,
    '^X': CMD_QUIT,
    '^c': CMD_SUICIDE,
    '^C': CMD_SUICIDE,
    }
    
def cmd_from_keypress(keypress):
    if(keypress not in KEYBINDINGS):
        print("Key not mapped!")
        return Command(CMD_NONE, None)
    cmd_code = KEYBINDINGS[keypress]
    arg = None
    if(cmd_code == CMD_MOVE):
        arg = DIRECTION_BINDINGS[keypress]
    return Command(cmd_code, arg)
        
    
class Command(object):
    """The command class describes a command in near complete detail."""
    def __init__(self, code, arg = None):
        if(code > MAX_COMMANDS):
            print("Bad command") #except here
        self._code = code
        self._arg = arg
    def arg(self, arg = None):
        if(arg == None): return self._arg
        self._arg = arg
    def code(self, code = None):
        if(code == None): return self._code
        self._code = code
        
class Prompt(object):
    """Prompt class, may build into AimPrompt, ItemPrompt, etc."""
    def __init__(self, prompt, type):
        self._prompt = prompt
        self._type = type
        self._response = None
    def prompt(self, prompt = None):
        if(prompt == None): return self._prompt
        self._prompt = prompt
    def type(self, type = None):
        if(type == None): return self._type
        self._type = type
    def response(self, response = None):
        if(response == None): return self._response
        self._response = response
        