﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ThornEngine
{
    abstract class VisibleObject
    {
        Location _loc;
        string _name;
        char _display;
        ThornColor _color;

        public VisibleObject()
        {
            _name = "";
            _loc = new Location(-1, -1);
        }
        public VisibleObject(string cname)
        {
            _name = cname;
            _loc = new Location(-1, -1);
        }
        public VisibleObject(int cx, int cy)
        {
            _name = "";
            _loc = new Location(cx, cy);
        }
        public VisibleObject(string cname, int cx, int cy)
        {
            _name = cname;
            _loc = new Location(cx, cy);
        }
        public VisibleObject(char cdisp, ThornColor ccolor)
        {
            _color = ccolor;
            _display = cdisp;
        }
        public VisibleObject(string cname, int cx, int cy, char cdisp, ThornColor ccolor)
        {
            _name = cname;
            _loc = new Location(cx, cy);
            _display = cdisp;
            _color = ccolor;
        }
        public ThornColor Color
        {
            get { return _color; }
            set { _color = value; }
        }
        public char Symbol
        {
            get { return _display; }
            set { _display = value; }
        }
        public string Name
        {
            get { return _name; }
            set { _name = value; }
        }
        public int x
        {
            get { return (_loc != null) ? _loc.x : -1; }
            set { _loc.x = value; }
        }
        public int y
        {
            get { return (_loc != null) ? _loc.y : -1; }
            set { _loc.y = value; }
        }
    }

    class Location
    {
        private int _x, _y;

        public Location() { _x = 0; _y = 0; }
        public Location(int cx, int cy) { _x = cx; _y = cy; }

        public int x
        {
            get { return _x; }
            set { _x = value; }
        }
        public int y
        {
            get { return _y; }
            set { _y = value; }
        }
        public override string ToString()
        {
            return x.ToString() + ", " + y.ToString();
        }
    }
}
