﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ThornEngine
{
    public enum ThornColor
    {
        BLACK = 0,
        WHITE,
        BLUE,
        RED,
        SLATE,
        DARKGRAY,
        YELLOW
    };
    class ThornGame
    //contains the core of the Thornwind engine code
    {
        public enum TKEY
        {
            UP,
            DOWN,
            LEFT,
            RIGHT,
            ESCAPE
        };
        Queue<ThornEvent> Events;
        ThornInterface Interface;
        Player p;
        Dungeon Level;
        MonsterCollection Monsters;
        public ThornGame(ThornInterface myInt)
        {
            Level = new Dungeon();
            Events = new Queue<ThornEvent>();
            Interface = myInt;
            Monsters = new MonsterCollection(myInt);
            Monsters.Add(new Monster("Test", 'T', AI.Type.CHASE, ThornColor.YELLOW, 4, 4));
            Monsters.Add(new Monster("Test2", 't', AI.Type.CHASE, ThornColor.RED, 4, 14));
            p = new Player("Test", 2, 2);
            Level.Display(myInt);
            Interface.DrawATXY(p.x, p.y, ThornColor.WHITE, '@');
            this.QueueEvent(new ThornEvent((int)ThornEvent.Event.REPAINT,0));
        }

        public void QueueEvent(ThornEvent e)
        {
            Events.Enqueue(e);
        }
        public void ProcessEvent()
        {
            if (Events.Count == 0) return; //no events
            ThornEvent eve = Events.Dequeue();
            switch (eve.EventCode)
            {
                case (int)ThornEvent.Event.KEYAVAILABLE:
                    {
                        //process a key
                        switch (eve.EventParams)
                        {
                            case (int)ThornGame.TKEY.UP:
                                {
                                    Interface.DebugMessage("Player Input: KeyUp");
                                    if (!Level.CanMove(p, Dungeon.Direction.NORTH)) break;
                                    p.y -= 1;
                                    this.QueueEvent(new ThornEvent((int)ThornEvent.Event.GAMERUN, 0));
                                    break;
                                }
                            case (int)ThornGame.TKEY.DOWN:
                                {
                                    Interface.DebugMessage("Player Input: KeyDown");
                                    if (!Level.CanMove(p, Dungeon.Direction.SOUTH)) break;
                                    p.y += 1;
                                    this.QueueEvent(new ThornEvent((int)ThornEvent.Event.GAMERUN, 0));
                                    break;
                                }
                            case (int)ThornGame.TKEY.LEFT:
                                {
                                    Interface.DebugMessage("Player Input: KeyLeft");
                                    if (!Level.CanMove(p, Dungeon.Direction.WEST)) break;
                                    p.x -= 1;
                                    this.QueueEvent(new ThornEvent((int)ThornEvent.Event.GAMERUN, 0)); 
                                    break;
                                }
                            case (int)ThornGame.TKEY.RIGHT:
                                {
                                    Interface.DebugMessage("Player Input: KeyRight");
                                    if (!Level.CanMove(p, Dungeon.Direction.EAST)) break;
                                    p.x += 1;
                                    this.QueueEvent(new ThornEvent((int)ThornEvent.Event.GAMERUN, 0));
                                    break;
                                }
                            case (int)ThornGame.TKEY.ESCAPE:
                                {
                                    this.QueueEvent(new ThornEvent((int)ThornEvent.Event.QUIT, 0));
                                    break;
                                }
                        }
                        break;
                    }
                case (int)ThornEvent.Event.REPAINT:
                    {
                        Level.Display(Interface);
                        Interface.Repaint();
                        Interface.ClearScreen(); 
                        break;
                    }
                case (int)ThornEvent.Event.GAMERUN:
                    {
                        Monsters.Look(p, Level);
                        Monsters.Act(p, Level);
                        Monsters.DisplayAll(Interface);
                        Interface.DrawATXY(p.x, p.y, ThornColor.WHITE, '@');
                        this.QueueEvent(new ThornEvent((int)ThornEvent.Event.REPAINT, 0));
                        break;
                    }
                case (int)ThornEvent.Event.QUIT:
                    {
                        //Alive = false;
                        Interface.Kill();
                        //cleanup
                        break;
                    }
            } //end switch
            this.ProcessEvent();
        }
    }

    class ThornEvent
    {
        /*
         * repaint
         * keyavailable
         * quit
         *
         */
        public enum Event
        {
            REPAINT,
            KEYAVAILABLE,
            GAMERUN,
            QUIT

        };
        int _eventcode;
        int _eventparams;
        public ThornEvent() { _eventcode = 0; _eventparams = 0; }
        public ThornEvent(int ec, int ep) { _eventcode = ec; _eventparams = ep; }
        public int EventCode
        {
            get { return _eventcode;}
            set { _eventcode = value;}
        }
        public int EventParams
        {
            get { return _eventparams; }
            set { _eventparams = value; }

        }
    }
}
