﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ThornEngine
{
    class MonsterCollection
    {
        ThornInterface Interface;
        List<Monster> _monsters;
        public MonsterCollection(ThornInterface ti)
        {
            Interface = ti;
            _monsters = new List<Monster>();
        }
        public void DisplayAll(ThornInterface e)
        {
            foreach (Monster m in _monsters)
            {
                e.DrawATXY(m.x, m.y, m.Color, m.Symbol);
            }
        }
        public void Add(Monster m)
        {
            _monsters.Add(m);
        }
        public void Look(Player p, Dungeon d)
        {
            foreach (Monster m in _monsters)
            {
                m.MonsterAI.Aware = true; //hack
            }
        }
        public void Act(Player p, Dungeon d)
        {
            foreach (Monster m in _monsters)
            {
                Interface.DebugMessage("Move Monster: "+m.Symbol+": "+System.String.Format("{0}",(int)m.MonsterAI.Move(m, p, d)));
            }
        }
    }

    class AI
    //Monster artificial Intelligence
    {
        public enum Type
        {
            STATIONARY,     //Doesn't move - VERY EASY TO DO HAHAHA
            RANDOM,         //Moves randomly (NYI)
            CHASE,          //Chases player
            SMELL,          //Chases player / smell (NYI)
            SMART           //Chases player intelligently (NYI)
        };
        Type _type;
        bool _aware;

        public AI()
        {
            _type = Type.STATIONARY;
            _aware = false;
        }
        public AI(Type ct)
        {
            _type = ct;
            _aware = false;
        }
        public bool Aware
        {
            get { return _aware; }
            set { _aware = value; }
        }
        public Type AIType
        {
            get { return _type; }
            set { _type = value; }
        }

        public Dungeon.Direction Move(Monster m, Player p, Dungeon d)
        {
            if (!m.Alive || !_aware) return Dungeon.Direction.NONE;
            //Dungeon.Direction dir;
            float tmx = (float)m.x;
            float tmy = (float)m.y;
            float tpx = (float)p.x;
            float tpy = (float)p.y;
            float dx = (tmx - tpx); dx *= dx;
            float dy = (tmy - tpy); dy *= dy;
            if (Math.Sqrt(dx + dy) <= 1.4143) return Dungeon.Direction.HIT;
            switch (_type)
            {
                case Type.STATIONARY:
                    break;
                case Type.RANDOM:
                    break;
                case Type.CHASE:
                    if (m.x < p.x) //West of player
                    {
                        if (m.y > p.y) //South of player
                        {
                            if (d.CanMove(m, Dungeon.Direction.NORTHEAST))
                            {
                                m.x++;
                                m.y--;
                                return Dungeon.Direction.NORTHEAST;
                            }
                            else if (d.CanMove(m, Dungeon.Direction.NORTH))
                            {
                                m.y--;
                                return Dungeon.Direction.NORTH;
                            }
                            else if(d.CanMove(m,Dungeon.Direction.EAST))
                            {
                                m.x++;
                                return Dungeon.Direction.EAST;
                            }
                        }
                        else if (m.y < p.y) //North of player
                        {
                            if (d.CanMove(m, Dungeon.Direction.SOUTHEAST))
                            {
                                m.x++;
                                m.y++;
                                return Dungeon.Direction.SOUTHEAST;
                            }
                            else if (d.CanMove(m, Dungeon.Direction.SOUTH))
                            {
                                m.y++;
                                return Dungeon.Direction.SOUTH;
                            }
                            else if (d.CanMove(m, Dungeon.Direction.EAST))
                            {
                                m.x++;
                                return Dungeon.Direction.EAST;
                            }
                        }
                        else
                        {
                            if (d.CanMove(m, Dungeon.Direction.EAST))
                            {
                                m.x++;
                                return Dungeon.Direction.EAST;
                            }
                        }
                    }//end west
                    else if (m.x > p.x) //East of player
                    {
                        if (m.y > p.y) //South of player
                        {
                            if (d.CanMove(m, Dungeon.Direction.NORTHWEST))
                            {
                                m.x--;
                                m.y--;
                                return Dungeon.Direction.NORTHWEST;
                            }
                            else if (d.CanMove(m, Dungeon.Direction.NORTH))
                            {
                                m.y--;
                                return Dungeon.Direction.NORTH;
                            }
                            else if (d.CanMove(m, Dungeon.Direction.WEST))
                            {
                                m.x--;
                                return Dungeon.Direction.WEST;
                            }
                        }
                        else if (m.y < p.y) //North of player
                        {
                            if (d.CanMove(m, Dungeon.Direction.SOUTHWEST))
                            {
                                m.x--;
                                m.y++;
                                return Dungeon.Direction.SOUTHWEST;
                            }
                            else if (d.CanMove(m, Dungeon.Direction.SOUTH))
                            {
                                m.y++;
                                return Dungeon.Direction.SOUTH;
                            }
                            else if (d.CanMove(m, Dungeon.Direction.WEST))
                            {
                                m.x--;
                                return Dungeon.Direction.WEST;
                            }
                        }
                        else
                        {
                            if (d.CanMove(m, Dungeon.Direction.WEST))
                            {
                                m.x--;
                                return Dungeon.Direction.WEST;
                            }
                        }
                    }//end east
                    else //monster is north or south of player
                    {
                        if (m.y > p.y) //south of player
                        {
                            if (d.CanMove(m, Dungeon.Direction.NORTH))
                            {
                                m.y--;
                                return Dungeon.Direction.NORTH;
                            }
                        }
                        else if (d.CanMove(m, Dungeon.Direction.SOUTH)) //works because the x==x y==y is covered at top
                        {
                            m.y++;
                            return Dungeon.Direction.SOUTH;
                        }
                    }
                    return Dungeon.Direction.NONE;
                    break;
                case Type.SMELL:
                    break;
                case Type.SMART:
                    break;
            }
            return Dungeon.Direction.NONE;
        }
    }

    class Monster : VisibleObject
    {
        bool _alive;
        AI _ai;

        public Monster() : base()
        {
            _ai = new AI();
            _alive=false;
        }
        public Monster(string cname, char csymbol, AI.Type cai, ThornColor ccolor, int cx, int cy) : base (cname, cx, cy, csymbol, ccolor)
        {
            _ai = new AI(cai);
            _alive = true;
        }
        public AI MonsterAI
        {
            get { return _ai; }
            set { _ai = value; }
        }
        public bool Alive
        {
            get { return _alive; }
            set { _alive = value; }
        }
        public bool Aware
        {
            get { return _ai.Aware; }
            set { _ai.Aware = value; }
        }
    }
}
