﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace ThornEngine
{
    public partial class ThornForm : Form
    {
        private System.Drawing.Font game_font;
        private WinThornInterface inter;
        private ThornGame Game;

        public ThornForm()
        {
            InitializeComponent();
        }

        private void ThornForm_Load(object sender, EventArgs e)
        {
            game_font = new Font(FontFamily.GenericMonospace, 14.0f);
            this.KeyDown += new KeyEventHandler(Thorn_KeyDown);
            //this.Paint += new PaintEventHandler(Thorn_Paint);
            this.Disposed += new EventHandler(ThornEngine_Dispose);
            this.KeyUp += new KeyEventHandler(Thorn_KeyUp);
            this.Init();
        }
        private void Init()
        {
            inter = new WinThornInterface(this.CreateGraphics(), game_font, this);
            Game = new ThornGame(inter);
        }
        public void DebugMessage(string s)
        {
            DebugTextBox.Text = s + Environment.NewLine + DebugTextBox.Text;
        }
        private void ThornEngine_Dispose(object sender, EventArgs e)
        {
            game_font.Dispose();
            //drawMe.Dispose();
        }
        private void Thorn_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
        {
            //Graphics g = e.Graphics;
            //g.Clear(Color.Black);
            //g.DrawImage(drawMe, 0, 0,830,400);
           // g.Dispose();
        }
        private void Thorn_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
        {
            switch (e.KeyCode)
            {
                case Keys.Up:
                    {
                        Game.QueueEvent(new ThornEvent((int)ThornEvent.Event.KEYAVAILABLE, (int)ThornGame.TKEY.UP));
                        break;
                    }
                case Keys.Down:
                    {
                        Game.QueueEvent(new ThornEvent((int)ThornEvent.Event.KEYAVAILABLE, (int)ThornGame.TKEY.DOWN));
                        break;
                    }
                case Keys.Left:
                    {
                        Game.QueueEvent(new ThornEvent((int)ThornEvent.Event.KEYAVAILABLE, (int)ThornGame.TKEY.LEFT));
                        break;
                    }
                case Keys.Right:
                    {
                        Game.QueueEvent(new ThornEvent((int)ThornEvent.Event.KEYAVAILABLE, (int)ThornGame.TKEY.RIGHT));
                        break;
                    }
                case Keys.Escape:
                    {
                        Game.QueueEvent(new ThornEvent((int)ThornEvent.Event.KEYAVAILABLE, (int)ThornGame.TKEY.ESCAPE));
                        //this.Dispose(); //quit
                        break;
                    }
            }
            Game.ProcessEvent();
            e.Handled = true;
        }
        private void Thorn_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
        {
            Game.ProcessEvent();
            e.Handled = true;
        }
    }
}