﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ThornEngine
{
    class Dungeon
    {
        public enum Walls
        {
            PERM = 0,
            FLOOR = 1,
            WALL = 9
        };
        public enum Direction
        {
            NONE,
            HIT,
            NORTH,
            SOUTH,
            EAST,
            WEST,
            NORTHEAST,
            SOUTHEAST,
            NORTHWEST,
            SOUTHWEST,
            UP,
            DOWN
        };
        //temporary level
        int[,] level =  {{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
                        {0,1,1,1,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,1,1,1,1,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,1,9,1,9,1,9,1,9,1,9,9,9,0},
                        {0,1,1,1,1,9,9,9,9,9,9,9,9,9,9,9,9,1,1,1,1,1,1,9,9,9,9,9,9,9,9,9,1,1,1,1,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,1,1,1,1,1,1,1,1,1,9,9,9,0},
                        {0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,9,9,9,9,9,9,9,9,9,1,1,1,1,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,1,1,1,1,1,9,9,9,9,9,1,9,1,1,1,1,1,9,1,9,9,9,0},
                        {0,1,1,1,1,9,9,9,9,9,9,9,9,9,9,9,9,1,1,1,1,1,1,9,9,9,9,9,9,9,9,9,9,9,9,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,1,1,1,1,1,1,1,1,1,1,1,1,1,1,9,1,1,1,1,9,9,9,0},
                        {0,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,1,1,1,1,1,1,9,9,9,9,9,9,9,9,9,9,9,9,1,9,9,9,1,1,1,1,1,1,9,9,9,9,9,9,9,9,9,9,9,9,1,1,1,1,1,9,9,9,9,9,1,9,1,1,1,1,1,9,1,9,9,9,0},
                        {0,9,9,9,9,1,1,1,1,1,1,1,1,1,9,9,9,1,1,1,1,1,1,9,9,9,9,9,9,9,9,9,9,9,9,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,9,9,9,9,9,1,1,1,1,1,1,1,1,1,9,9,9,0},
                        {0,9,9,9,9,9,1,1,1,1,1,1,1,9,9,9,9,9,9,9,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,1,1,1,1,1,1,9,9,9,9,9,9,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,1,9,1,9,1,9,1,9,1,9,9,9,0},
                        {0,9,9,9,9,9,9,1,1,1,1,1,9,9,9,9,9,9,9,9,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,1,1,1,1,1,1,9,9,9,9,9,9,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0},
                        {0,9,9,9,9,9,9,9,1,1,1,9,9,9,9,9,9,9,9,9,1,9,9,9,9,9,9,9,9,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,9,9,9,9,9,9,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0},
                        {0,9,9,9,9,9,9,9,9,1,9,9,9,9,9,9,9,9,9,9,1,9,9,9,9,9,9,9,9,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0},
                        {0,9,9,9,9,9,9,9,9,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,1,9,9,9,9,9,1,1,1,1,1,1,1,1,1,1,1,1,9,9,9,9,9,9,9,9,9,9,0},
                        {0,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,1,9,9,9,9,9,9,9,9,9,9,9,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,1,9,9,9,9,1,1,9,9,1,1,9,9,1,1,9,9,1,1,9,9,9,9,9,9,9,9,9,0},
                        {0,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,1,9,9,9,9,9,9,9,9,9,9,9,1,9,9,9,1,1,1,1,1,1,1,1,9,9,9,9,9,9,9,9,9,9,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,9,9,9,9,9,9,9,9,0},
                        {0,1,1,1,1,1,1,1,1,1,1,1,9,9,9,9,9,1,9,9,9,9,9,9,9,9,9,9,9,1,1,1,1,1,1,1,1,1,1,1,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,1,1,9,9,1,1,9,9,1,1,9,9,1,1,9,9,9,9,9,9,9,9,9,0},
                        {0,9,1,1,1,1,1,1,1,1,1,1,1,9,9,9,9,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,1,1,1,1,1,1,1,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,1,1,1,1,1,1,1,1,1,1,1,1,9,9,9,9,9,9,9,9,9,9,0},
                        {0,9,9,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0},
                        {0,9,9,9,1,1,1,1,1,1,1,1,1,1,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0},
                        {0,9,9,9,9,1,1,1,1,1,1,1,1,1,1,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0},
                        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}};

        public Dungeon()
        {
        }
        /*public bool CanMove(VisibleObject p, Direction direction)
        {
            int tx = p.x;
            int ty = p.y;
            switch (direction)
            {
                case Direction.NORTH:
                    ty -= 1;
                    break;
                case Direction.SOUTH:
                    ty += 1;
                    break;
                case Direction.EAST:
                    tx += 1;
                    break;
                case Direction.WEST:
                    tx -= 1;
                    break;
                case Direction.NORTHEAST:
                    ty -= 1;
                    tx += 1;
                    break;
                case Direction.SOUTHEAST:
                    ty += 1;
                    tx += 1;
                    break;
                case Direction.NORTHWEST:
                    ty -= 1;
                    tx -= 1;
                    break;
                case Direction.SOUTHWEST:
                    ty += 1;
                    tx -= 1;
                    break;
                case Direction.UP:
                    return false; //nyi
                    break;
                case Direction.DOWN:
                    return false; //nyi
                    break;
                default:
                    return false;
            }
            if ((tx < 0 || tx > 79) || (ty < 0 || ty > 19)) return false; //out of bounds
            if (level[ty, tx] != (int)Walls.FLOOR) return false;
            return true;
        }*/
        public bool CanMove(VisibleObject vo, Direction direction)
        {
            //ADD DIRECTIONAL HITS SO WE KNOW WHAT WE ARE ATTACKING
            int tx = vo.x;
            int ty = vo.y;
            switch (direction)
            {
                case Direction.NORTH:
                    ty -= 1;
                    break;
                case Direction.SOUTH:
                    ty += 1;
                    break;
                case Direction.EAST:
                    tx += 1;
                    break;
                case Direction.WEST:
                    tx -= 1;
                    break;
                case Direction.NORTHEAST:
                    ty -= 1;
                    tx += 1;
                    break;
                case Direction.SOUTHEAST:
                    ty += 1;
                    tx += 1;
                    break;
                case Direction.NORTHWEST:
                    ty -= 1;
                    tx -= 1;
                    break;
                case Direction.SOUTHWEST:
                    ty += 1;
                    tx -= 1;
                    break;
                default:
                    return false;
            }
            if ((tx < 0 || tx > 79) || (ty < 0 || ty > 19)) return false; //out of bounds
            if (level[ty, tx] != (int)Walls.FLOOR) return false;
            return true;
        }
        public void Display(ThornInterface e)
        {
            for (int i = 0; i < 80; i++)
            {
                for (int j = 0; j < 20; j++)
                {
                    switch (level[j,i])
                    {
                        case 0:
                            e.DrawATXY(i, j, ThornColor.SLATE, '#');
                            break;
                        case 1:
                            e.DrawATXY(i, j, ThornColor.WHITE, '.');
                            break;
                        case 9:
                            e.DrawATXY(i, j, ThornColor.DARKGRAY, '#');
                            break;
                    }
                }
            }
        }
    }
}
