﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Linq;

namespace ThornEngine
{
    abstract class ThornInterface
    //this class needs to be modified at a per OS basis.
    {
        public abstract void Repaint();
        public abstract void Kill();
        public abstract void DrawATXY(int x, int y, ThornColor color, char c);
        public abstract void ClearScreen();
        public abstract void DebugMessage(string msg);
        public abstract void DebugPopup(string msg);
    }
    class WinThornInterface : ThornInterface
    {
        protected Bitmap drawMe;
        protected Graphics GFX;
        protected Graphics WGFX;
        protected Font GameFont;
        protected ThornForm ParentForm;
        public WinThornInterface(Graphics cWGFX, Font cGameFont, ThornForm cParentForm)
        {
            WGFX = cWGFX;
            drawMe = new Bitmap(830, 400, System.Drawing.Imaging.PixelFormat.Format24bppRgb);
            GFX = Graphics.FromImage(drawMe);
            GameFont = cGameFont;
            ParentForm = cParentForm;
        }
        public override void DebugMessage(string msg)
        {
            ParentForm.DebugMessage(msg);
        }
        public override void DebugPopup(string msg)
        {
            System.Windows.Forms.MessageBox.Show(msg);
        }
        public override void Kill()
        {
            Application.Exit();
        }
        public override void Repaint()
        {
            WGFX.DrawImage(drawMe,0,0);
        }
        public override void ClearScreen()
        {
            GFX.Clear(Color.Black);
        }
        public override void DrawATXY(int x, int y, ThornColor color, char c)
        {
            GFX.DrawString(c.ToString(), GameFont, GetBrushFromColor(color), x * 10, y * 16);
        }
        private Brush GetBrushFromColor(ThornColor col)
        {
            //hacky, fix with a proper enum and such.
            switch (col)
            {
                case ThornColor.BLACK:
                    return Brushes.Black;
                case ThornColor.WHITE:
                    return Brushes.White;
                case ThornColor.BLUE:
                    return Brushes.Blue;
                case ThornColor.RED:
                    return Brushes.Red;
                case ThornColor.SLATE:
                    return Brushes.SlateGray;
                case ThornColor.DARKGRAY:
                    return Brushes.DarkGray;
                case ThornColor.YELLOW:
                    return Brushes.Yellow;
            }
            return Brushes.Black; //default
        }
    }
}
